/*
	This script drops and recreates the database Synonyms 
*/

USE @UT_DB_NAME@ 
GO

CREATE TABLE #tmpDropSynonyms
(
	sqlId INT IDENTITY(1,1),
	sqlCommand VARCHAR(4000)
)

INSERT INTO #tmpDropSynonyms (sqlCommand)
SELECT 'DROP Synonym [dbo].' + name FROM sys.synonyms

DECLARE @ndxCounter INT
DECLARE @maxCounter INT
DECLARE @sql	    VARCHAR(4000)

SELECT @ndxCounter = 1, @maxCounter = COUNT(1) FROM #tmpDropSynonyms 


WHILE @ndxCounter <=  @maxCounter
	BEGIN
		SELECT 
			@sql = sqlCommand
		FROM 
			#tmpDropSynonyms
		WHERE 
			sqlId = @ndxCounter 
		
		IF @@ERROR <> 0 
		BEGIN    
			RAISERROR( 'Error preparing dynamic SQL to drop Synonym', 16, 1 )
		END
		
		EXEC( @sql )
		
		IF @@ERROR <> 0 
		BEGIN
			RAISERROR( 'Error trying to drop Synonym with dynamic SQL:%s', 16, 1, @sql )
		END                
		
		SET @ndxCounter = @ndxCounter + 1
	END


DROP TABLE #tmpDropSynonyms


CREATE TABLE #tmpCreateSynonyms
(
	sqlId INT IDENTITY(1,1),
	sqlCommand VARCHAR(4000)
)


INSERT INTO #tmpCreateSynonyms(sqlCommand)
SELECT 'CREATE SYNONYM [dbo].[SynMirror_' + so.name + '] FOR [@UT_DB_NAME@_MIRROR].[dbo].[' + so.name + ']' FROM @UT_DB_NAME@_MIRROR.sys.sysobjects so WHERE so.Xtype IN ('U','V') AND so.name <> 'dtProperties'
 

SELECT @ndxCounter = 1, @maxCounter = COUNT(1) FROM #tmpCreateSynonyms


WHILE @ndxCounter <=  @maxCounter
	BEGIN
		SELECT 
			@sql = sqlCommand
		FROM 
			#tmpCreateSynonyms
		WHERE 
			sqlId = @ndxCounter 
		
		IF @@ERROR <> 0 
		BEGIN    
			RAISERROR( 'Error preparing dynamic SQL to create Synonym', 16, 1 )
		END
		
		EXEC( @sql )
		
		IF @@ERROR <> 0 
		BEGIN
			RAISERROR( 'Error trying to create Synonym with dynamic SQL:%s', 16, 1, @sql )
		END                
		
		SET @ndxCounter = @ndxCounter + 1
	END


DROP TABLE #tmpCreateSynonyms
/*
	This script drops and recreates the Mirror database Synonyms 
*/
USE @UT_DB_NAME@_MIRROR 
GO

CREATE TABLE #tmpDropSynonyms
(
	sqlId INT IDENTITY(1,1),
	sqlCommand VARCHAR(4000)
)

INSERT INTO #tmpDropSynonyms (sqlCommand)
SELECT 'DROP Synonym [dbo].' + name FROM sys.synonyms

DECLARE @ndxCounter INT
DECLARE @maxCounter INT
DECLARE @sql	    VARCHAR(4000)

SELECT @ndxCounter = 1, @maxCounter = COUNT(1) FROM #tmpDropSynonyms 


WHILE @ndxCounter <=  @maxCounter
	BEGIN
		SELECT 
			@sql = sqlCommand
		FROM 
			#tmpDropSynonyms
		WHERE 
			sqlId = @ndxCounter 
		
		IF @@ERROR <> 0 
		BEGIN    
			RAISERROR( 'Error preparing dynamic SQL to drop Mirror Synonym', 16, 1 )
		END
		
		EXEC( @sql )
		
		IF @@ERROR <> 0 
		BEGIN
			RAISERROR( 'Error trying to drop Mirror Synonym with dynamic SQL:%s', 16, 1, @sql )
		END                
		
		SET @ndxCounter = @ndxCounter + 1
	END


DROP TABLE #tmpDropSynonyms


CREATE TABLE #tmpCreateSynonyms
(
	sqlId INT IDENTITY(1,1),
	sqlCommand VARCHAR(4000)
)


INSERT INTO #tmpCreateSynonyms(sqlCommand)
SELECT 'CREATE SYNONYM [dbo].[Syn_' + so.name + '] FOR [@UT_DB_NAME@].[dbo].[' + so.name + ']' FROM @UT_DB_NAME@.sys.sysobjects so WHERE so.Xtype IN ('U') AND so.name <> 'dtProperties'
 

SELECT @ndxCounter = 1, @maxCounter = COUNT(1) FROM #tmpCreateSynonyms


WHILE @ndxCounter <=  @maxCounter
	BEGIN
		SELECT 
			@sql = sqlCommand
		FROM 
			#tmpCreateSynonyms
		WHERE 
			sqlId = @ndxCounter 
		
		IF @@ERROR <> 0 
		BEGIN    
			RAISERROR( 'Error preparing dynamic SQL to create Mirror Synonym', 16, 1 )
		END
		
		EXEC( @sql )
		
		IF @@ERROR <> 0 
		BEGIN
			RAISERROR( 'Error trying to create Mirror Synonym with dynamic SQL:%s', 16, 1, @sql )
		END                
		
		SET @ndxCounter = @ndxCounter + 1
	END


DROP TABLE #tmpCreateSynonyms
